%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function post_process_contour(iteration)
close all;

filename = ['init_to_inter_lsm_', num2str(iteration)];
fid = fopen(filename, 'r');

A = fscanf(fid, '%f %f', [2 inf]); 
A = A';
A = A(1:end-1,:);
fclose(fid); 

[B, index] = unique(A, 'rows'); 

BX = sort(index); 

filename = ['init_to_inter_lsm_', num2str(iteration), '_unique'];
fid = fopen(filename, 'w'); 

for i=1:size(BX,1)
    x = A(BX(i),1);
    y = A(BX(i),2);
    fprintf(fid, '%f\t%f\n', x, y);
    C(i,:) = [x;y];
end
fclose(fid); 


figure; 
plot(C(:,1), C(:,2));
hold on; 
plot(C(1,1), C(1,2), 'x', 'MarkerSize', 10, 'MarkerEdgeColor', 'r'); 
hold on; 
plot(C(100,1), C(100,2), 'x', 'MarkerSize', 10, 'MarkerEdgeColor', 'k');


